 ; Ŀ
 ;   Cto - rearrange text by rows into a stack.                            
 ;   Copyright 2000, 2002, 2003, 2007, 2010 by Rocket Software Ltd.        
 ;                                                                         
 ; 

 ; Ŀ
 ;   Subroutine Phoebe - make a stack of text entities.                    
 ;   Arguments: Pa, a start point.                                         
 ;              Strlst, a list of lists of strings.                        
 ;              Texth, a text height.                                      
 ;              Upca, convert to uppercase?.                               
 ;   Calls its Granny, Returns nothing.                                    
 ; 
 (DEFUN PHOEBE (pa strlst texth upca / incr num sub str pa)
  (setq incr (* 1.75 texth))      ; but 1.65 for normal spacing
  (setq num 0)
  (setvar "cecolor" "1")
  (while (setq sub (nth num strlst))
         (setq num (1+ num))
         (while (setq str (car sub))
                (if upca (setq str (strcase str)))
                (setq sub (cdr sub))
                (command "text" pa texth 0 str)
                (setq pa (polar pa (* pi 1.5) incr)))
         (setvar "cecolor" (itoa (1+ (read (getvar "cecolor")))))
         (setq pa (polar pa (* pi 1.5) incr)))
 (princ))
 ; Ŀ
 ;   Subroutine Phoebe end.                                                
 ; 

 ; Ŀ
 ;   Getins - get the insertion point for a text entity depending on its   
 ;   justification.                                                        
 ;   Arguments: enam, the entity name; the entity must be text.            
 ;   Calls nothing, returns a point.                                       
 ; 
 (DEFUN GETINS (enam / entt asoc72 typ72 inspt)
  (setq entt (entget enam))             ; entity data
  (if (setq asoc72 (assoc 72 entt))
      (setq typ72 (cdr asoc72))         ; text justification
      (setq typ72 1))                   ; is this possible?
 ; Ŀ
 ;   Get the text insertion point.  This will be either the 10 or 11       
 ;   depending on the justification.                                       
 ;   Note that the Y coordinate of i.e. middle left justified text is not  
 ;   the same as the Y for left justified text, so the Y coord should      
 ;   be extracted from the 10 point, which is always the baseline, and     
 ;   the X should be extracted from whichever of the 10 or 11 is used      
 ;   as the insertion, depending on the justification.                     
 ; 
  (cond ((or (= typ72 2)                ; right
             (= typ72 4)                ; or middle
             (= typ72 1))               ; or centred
         (setq inspt (cdr (assoc 11 entt))))
        ((or (= typ72 3)                ; aligned
             (= typ72 0)                ; or left justified
             (= typ72 5))               ; or fit
         (setq inspt (cdr (assoc 10 entt)))))
 inspt)
 ; Ŀ
 ;   Getins end.                                                           
 ; 

 ; Ŀ
 ;   Lschop - split an ordered list into sublists, each consisting of a    
 ;   number and all the ones within a specified distance after it.         
 ;   This simply involves removing them from the front of the ordered      
 ;   list and adding them to sublists.                                     
 ;   Takes two arguments, the ordered list and the distance.               
 ; 
 (DEFUN LSCHOP (xlist fuzz / num xlist major sub malist)
  (while (setq num (car xlist))
         (setq xlist (cdr xlist))
         (cond ((null major)
                (setq major num)
                (setq sub (list major)))
               ((>= (+ major fuzz) num)
                (setq sub (cons num sub)))
               (T
                (setq major num)
                (setq malist (append malist (list (reverse sub))))
                (setq sub (list major)))))
 ; Ŀ
 ;   We are now out of the loop, so close things down neatly.              
 ; 
  (setq malist (append malist (list (reverse sub))))
 malist)
 ; Ŀ
 ;   Lschop end.                                                           
 ; 

 ; Ŀ
 ;   Ls - put a list into numerical order.                                 
 ;   Takes one argument, a list of numbers.                                
 ;   Returns the list in increasing order.                                 
 ; 
 (DEFUN LS (alist / mxa gnulis list1 num list0 sub)
  (while alist
         (setq mxa (eval (cons max alist)))
         (setq gnulis (cons mxa gnulis))
         (setq list1 (cdr (member mxa alist)))
         (setq num 0)
         (setq list0 ())
         (while (/= (setq sub (nth num alist)) mxa)
                (setq num (1+ num))
                (setq list0 (cons sub list0)))
         (setq alist (append (reverse list0) list1)))
 gnulis)
 ; Ŀ
 ;   Ls end.                                                               
 ; 

 ; Ŀ
 ;   Subroutine Snort: extract strings from an ss of text into a list of   
 ;   lists of values by row.                                               
 ;   Arguments: ss, the selection set of text entities.                    
 ;              fuzz, the allowable positional misalignment.               
 ; 
 (DEFUN SNORT (ss fuzz / num enam entt inspt xlist xover sub xposls ylist
                         yover yposls xnum xpos ynum gnusub ypos pa found
                                                               ten malist)
 ; Ŀ
 ;   Make a list of X positions.                                           
 ; 
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq inspt (getins enam))
 ; Ŀ
 ;   Add the X coordinate to Xlist.                                        
 ; 
         (setq xlist (cons (car inspt) xlist))
         (setq num (1+ num)))
 ; Ŀ
 ;   Put the X position list in numerical order.                           
 ; 
  (setq xlist (ls xlist))
 ; Ŀ
 ;   Get the entity with the lowest X coordinate, then add all the ones    
 ;   within the fuzz factor to its sublist, repeat while there is a list.  
 ; 
  (setq xover (lschop xlist fuzz))
 ; Ŀ
 ;   Extract the first value from each sublist to make a list of column    
 ;   positions.                                                            
 ; 
  (while (setq sub (car xover))
         (setq num (car sub))
         (setq xover (cdr xover))
         (setq xposls (append xposls (list num))))
 ; Ŀ
 ;   *** Now do the same again for Y positions. ***                        
 ;   Make a list of Y positions.                                           
 ; 
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq ylist (cons (cadr (getins enam)) ylist))
         (setq num (1+ num)))
 ; Ŀ
 ;   Put the Y position list in numerical order.                           
 ; 
  (setq ylist (ls ylist))
 ; Ŀ
 ;   Get the entity with the lowest y coordinate, then add all the ones    
 ;   within the fuzz factor to its sublist, repeat while there is a list.  
 ; 
  (setq yover (lschop ylist fuzz))
 ; Ŀ
 ;   Extract the first value from each sublist to make a list of column    
 ;   positions.                                                            
 ; 
  (while (setq sub (car yover))
         (setq num (car sub))
         (setq yover (cdr yover))
         (setq yposls (append yposls (list num))))
         (setq yposls (reverse yposls))
 ; Ŀ
 ;   Now have a list of the position of each column and each row.          
 ;   Want to check to see if there is anything at each position.           
 ;   What if there are two entities on top of each other, or within        
 ;   the fuzz limit both ways?  Put both in one field, separate with       
 ;   a marker: ::: or something.                                           
 ; 
  (setq ynum 0)
  (while (setq ypos (nth ynum yposls))
         (setq ynum (1+ ynum))
         (setq xnum 0)
         (setq gnusub ())
         (while (setq xpos (nth xnum xposls))
                (setq xnum (1+ xnum))
                (setq pa (list xpos ypos))
                (setq num 0)
                (setq found "")
                (while (setq enam (ssname ss num))
                       (setq num (1+ num))
                       (setq ten (getins enam))
 ; Ŀ
 ;   Kill the Z coordinate off the text 10 point: equal apparently         
 ;   doesn't work with lists of different length, and we aren't concerned  
 ;   with the elevation of the text entity.  (There shouldn't be one,      
 ;   but don't bet on it.)                                                 
 ; 
                        (setq ten (reverse (cdr (reverse ten))))
                        (cond ((and (equal ten pa fuzz) (/= found ""))
                               (setq found (strcat found ":::"
                                               (cdr (assoc 1 (entget enam))))))
                              ((equal ten pa fuzz)
                               (setq found (cdr (assoc 1 (entget enam)))))))
                (setq gnusub (append gnusub (list found))))
                (setq malist (append malist (list gnusub))))
 malist)
 ; Ŀ
 ;   Subroutine Snort end.                                                 
 ; 

 ; Ŀ
 ;   Cto.                                                                  
 ; 
 (DEFUN C:CTO (/ snapp osm cecolo *error* ss fuzz malist pa texth)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
  (setq osm (getvar "osmode"))
  (setq cecolo (getvar "cecolor"))
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (setvar "snapmode" snapp)
   (setvar "osmode" osm)
   (setvar "cecolor" cecolo)
   (command "undo" "end")
   (if shk (write-line shk)))
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
 ; Ŀ
 ;   Get entities.                                                         
 ; 
  (if (setq ss (ssget (list (cons 0 "text"))))
      (progn
 ; Ŀ
 ;   Get a fuzz value for position equality.                               
 ; 
          (setq fuzz (cdr (assoc 40 (entget (ssname ss 0)))))
 ; Ŀ
 ;   Call subroutine Snort to extract the entities into a grid.            
 ; 
          (setq malist (snort ss fuzz))))
 ; Ŀ
 ;   If malist exists, get a point.                                        
 ; 
  (setq pa (getpoint "Base point: "))
  (setq texth (* (misps) 2.5))
  (setvar "osmode" 0)
 ; Ŀ
 ;   Call Phoebe to make the stack of text.                                
 ; 
  (phoebe pa malist texth t)
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* nil)
 (princ))